cronjobs.controllers.module('list_elements',
    [],
    () => {
        return {
            vue: true,
            name: 'gx-cronjobs-list-elements',
            parent: 'gx-cronjobs-overview',
            template: '#cronjobs-list-elements',
            props: {
                cronjobs: {
                    required: true,
                    type: Array
                }
            },
            data: () => ({
                lang: {
                    sub_title_tasks: jse.core.lang.translate('sub_title_tasks', 'cronjobs'),
                    status_inactive_description: jse.core.lang.translate('status_inactive_description', 'cronjobs'),
                    status_inactive: jse.core.lang.translate('status_inactive', 'cronjobs'),
                    status_active_description: jse.core.lang.translate('status_active_description', 'cronjobs'),
                    status_active: jse.core.lang.translate('status_active', 'cronjobs'),
                    status_warning_description: jse.core.lang.translate('status_warning_description', 'cronjobs'),
                    status_error_description: jse.core.lang.translate('status_error_description', 'cronjobs'),
                    status_not_executed_description: jse.core.lang.translate('status_not_executed_description', 'cronjobs'),
                }
            }),
            methods: {
                getPhrase(title) {
                    const phraseSection = title.split('.');
                    const section = phraseSection[0];
                    const phrase = phraseSection[1];

                    return jse.core.lang.translate(phrase, section);
                },
                getInterval(title, interval) {
                    const phraseSection = title.split('.');
                    const section = phraseSection[0];

                    return jse.core.lang.translate(interval, section);
                },
                openLogsModal(cronjob) {
                    this.$emit('open-logs-modal', cronjob);
                },
                openConfigurationModal(cronjob) {
                    this.$emit('open-configuration-modal', cronjob)
                }
            },
            init: done => done()
        }
    });